/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.BackEnd;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.core.Specifier;
import jade.imtp.leap.Command;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.MicroStub;
import jade.lang.acl.ACLMessage;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.util.Vector;

public class BackEndStub
extends MicroStub
implements BackEnd {
    static final int BORN_AGENT = 20;
    static final int DEAD_AGENT = 21;
    static final int SUSPENDED_AGENT = 22;
    static final int RESUMED_AGENT = 23;
    static final int MESSAGE_OUT = 24;

    public BackEndStub(Dispatcher d) {
        super(d);
    }

    public String bornAgent(String name) throws JADESecurityException, IMTPException {
        Command c = new Command(20);
        c.addParam(name);
        Command r = this.executeRemotely(c, 0L);
        if (r.getCode() == 2) {
            throw new JADESecurityException((String)r.getParamAt(2));
        }
        if (r.getParamCnt() > 0) {
            return (String)r.getParamAt(0);
        }
        return null;
    }

    public void deadAgent(String name) throws IMTPException {
        Command c = new Command(21);
        c.addParam(name);
        this.executeRemotely(c, -1L);
    }

    public void suspendedAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(22);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public void resumedAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(23);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public void messageOut(ACLMessage msg, String sender) throws NotFoundException, IMTPException {
        Command c = new Command(24);
        c.addParam(msg);
        c.addParam(sender);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public static final void parseCreateMediatorResponse(String responseMessage, Properties pp) {
        Vector v = Specifier.parseList(responseMessage, '#');
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s.length() > 0) {
                try {
                    int index = s.indexOf(61);
                    String key = s.substring(0, index);
                    String value = s.substring(index + 1);
                    pp.setProperty(key, value);
                }
                catch (Exception e) {
                    Logger.println("Property format error: " + s);
                    e.printStackTrace();
                }
                String mediatorId = pp.getProperty("mediator-id");
                if (mediatorId != null) {
                    pp.setProperty("container-name", mediatorId);
                }
            }
            ++i;
        }
    }

    public static final StringBuffer encodeCreateMediatorRequest(Properties pp) {
        StringBuffer sb = new StringBuffer();
        BackEndStub.appendProp(sb, "mediator-class", pp.getProperty("mediator-class"));
        BackEndStub.appendProp(sb, "max-disconnection-time", pp.getProperty("max-disconnection-time"));
        BackEndStub.appendProp(sb, "beaddrs", pp.getProperty("beaddrs"));
        BackEndStub.appendProp(sb, "owner", pp.getProperty("owner"));
        BackEndStub.appendProp(sb, "agents", pp.getProperty("agents"));
        BackEndStub.appendProp(sb, "keep-alive-time", pp.getProperty("keep-alive-time"));
        return sb;
    }

    public static void appendProp(StringBuffer sb, String key, String val) {
        if (val != null && val.length() != 0) {
            sb.append(key);
            sb.append('=');
            sb.append(val);
            sb.append('#');
        }
    }
}

